local ZGV = ZygorGuidesViewer
if not ZGV then return end

local GuideMenu = ZGV.GuideMenu

GuideMenu.HomeVersion = 1
GuideMenu.HomeMessage = [[
Welcome to Zygor's Classic Guides

Please contact Customer Support if you encounter any issues.
]]
GuideMenu.Home={
	{"banner", image=ZGV.IMAGESDIR.."banner"},

	{"title", text=[[December 16th, 2021]]},
	{"list", text=[[Added **Feast of Winter Veil Quest**]], guide="EVENTS\\Feast of Winter Veil\\Feast of Winter Veil Quest"},


	{"title", text=[[Version 1.0.22761]]},

	{"section", text=[[LEVELING]]},
	{"item", text=[[Added |cfffe6100Scepter of the Shifting Sands|r.]], guide="LEVELING\\Scepter of the Shifting Sands"},
	{"item", text=[[Added |cfffe6100Ruins of Ahn'Qiraj Cloak Quest|r.]], guide="LEVELING\\Ruins of Ahn'Qiraj Cloak Quest"},
	{"item", text=[[Added |cfffe6100Ruins of Ahn'Qiraj Ring Quest|r.]], guide="LEVELING\\Ruins of Ahn'Qiraj Ring Quest"},
	{"item", text=[[Added |cfffe6100Ruins of Ahn'Qiraj Weapon Quest|r.]], guide="LEVELING\\Ruins of Ahn'Qiraj Weapon Quest"},
	{"item", text=[[Added |cfffe6100Temple of Ahn'Qiraj Shoulder Quest|r.]], guide="LEVELING\\Temple of Ahn'Qiraj Shoulder Quest"},
	{"item", text=[[Added |cfffe6100Temple of Ahn'Qiraj Boots Quest|r.]], guide="LEVELING\\Temple of Ahn'Qiraj Boots Quest"},
	{"item", text=[[Added |cfffe6100Temple of Ahn'Qiraj Helm Quest|r.]], guide="LEVELING\\Temple of Ahn'Qiraj Helm Quest"},
	{"item", text=[[Added |cfffe6100Temple of Ahn'Qiraj Legs Quest|r.]], guide="LEVELING\\Temple of Ahn'Qiraj Legs Quest"},
	{"item", text=[[Added |cfffe6100Temple of Ahn'Qiraj Chest Quest|r.]], guide="LEVELING\\Temple of Ahn'Qiraj Chest Quest"},
	{"item", text=[[Added |cfffe6100Signet Ring of the Bronze Dragonflight|r.]], guide="LEVELING\\Signet Ring of the Bronze Dragonflight"},
	{"item", text=[[Added |cfffe6100Cenarion Battlegear|r.]], guide="LEVELING\\Cenarion Battlegear"},
	{"item", text=[[Added |cfffe6100Cenarion Field Duty Combat Assignments|r.]], guide="LEVELING\\Cenarion Field Duty Combat Assignments"},
	{"item", text=[[Added |cfffe6100Cenarion Field Duty Tactical Assignments|r.]], guide="LEVELING\\Cenarion Field Duty Tactical Assignments"},
	{"item", text=[[Added |cfffe6100Cenarion Field Duty Logistics Assignments|r.]], guide="LEVELING\\Cenarion Field Duty Logistics Assignments"},

}


--toast content
GuideMenu.Welcome={	--Welcome Toast

	{"title", text=[[Welcome to Zygor Guides]], fontsize = 12, center = true, volume = ZGV.FontBold},


	{"list", text=[[See the **new WoW Classic Guides**]], fontsize = 10, size = "S", onclick=function() ZGV.GuideMenu:Show("Featured") GuideMenu.ToastQueuePush() end },

}
GuideMenu.Updates={	--General Updates Toast

	{"title", text=[[New in this update:]], fontsize = 12, center = true, volume = ZGV.FontBold},

	{"list", text=[[Updated the **Spark of Ingenuity guide** for the Dragonflight Campaign]], fontsize = 9, size = "S", onclick=function() ZGV.GuideMenu:Show("LEVELING\\The Spark of Ingenuity") GuideMenu.ToastQueuePush() end},
	{"list", text=[[Added The **Silver Purpose chapter** to the Valdrakken Accord rep guide]], fontsize = 9, size = "S", onclick=function() ZGV.GuideMenu:Show("REPUTATIONS\\Valdrakken Accord") GuideMenu.ToastQueuePush() end},

}
GuideMenu.Orientation={	--Orientation Guide Toast

	{"title", text=[[Zygor Messages:]], fontsize = 12, center = true, volume = ZGV.FontBold},

	{"text", text=[[We suggest using the **Startup Orientation Wizard** while in town. This will improve travel directions, gold guide recommendations, and more.]], fontsize = 9},
	{"text", text=[[Would you like to load this in a new tab?]], fontsize = 9},

}
GuideMenu.Events={	--Ongoing Event Toast
	event = "Love is in the Air",
	{"title", text=[[Zygor Messages:]], fontsize = 12, center = true, volume = ZGV.FontBold},

	{"text", text=[[The **Love is in the Air** Event is underway!]], fontsize = 9},
	{"banner", image=ZGV.IMAGESDIR.."Vashjir", top=0, left=0, bottom=512/512, right=256/256},
	{"text", text=[[**See the guides**]], fontsize = 9, onclick=function() ZGV.GuideMenu:Show() ZGV.GuideMenu:Open("EVENTS\\Love is in the Air") GuideMenu.ToastQueuePush() end},

}

--GuideMenu.Toast5={	--World Quest Reset Toast (unused - contents for world quests reset are generated as formatted text, not a parser object)

--	{"title", text=[[Zygor Messages:]], fontsize = 12, center = true, volume = ZGV.FontBold},

--	{"text", text=[[World Quests have reset on this server.]], center = true, fontsize = 9},

--}

GuideMenu.Sticky = {

	["welcome"] = true,
	["updates"] = false,
	["orientation"] = true,
	["events"] = true,
	["dailyquests"] = false,
	["worldquests"] = false,

}

GuideMenu.DisplayMode = {		--values: show (display the toast when conditionsa are met), hide (never display the toast), dev (display when conditions met, but in dev clients only)

	["welcome"] = "hide",
	["updates"] = "hide",
	["orientation"] = "show",
	["events"] = "show",
	["dailyquests"] = "show",
	["worldquests"] = "show",

}

-- faction="Alliance" {"separator"},

function GuideMenu.ToastQueuePush()

	ZGV.NotificationCenter.FloatingToast:Hide()
	if ZGV.NotificationCenter.QueuedToasts[1] then table.remove(ZGV.NotificationCenter.QueuedToasts,1) end
	ZGV.NotificationCenter:QueueToast()

end